#ifndef __OS_H__
#define __OS_H__

/**
 *
 * \file        os.h
 *
 * \brief       Generic, very simple operating system interface
 *
 * \author      Pete McCormick
 *
 * \date        12/5/2007
 *
 * If this interface does not provide sufficient functionality,
 * we need to extend it since the code should be os independent
 */

////////////////////////////////////////////////////////////////////////////////

#include "dm_os.h"

#ifdef __cplusplus
extern "C" {
#endif

// Task Priorities
#define OS_DEFAULT_PRIORITY 0
#define CONSOLE_TASK_PRIORITY 0
#define CRESNET_SLAVE_TASK_PRIORITY 0
#define CRESNET_HOST_TASK_PRIORITY 0
#define OS_TIMER_PRIORITY 0 //4 //100

#ifdef STR91X_IAR
 #define OS_TIMER_STACK_INCREASE         (120/sizeof(UINT32))
#else 
 #ifdef IAR_ARM_CM3
  #define OS_TIMER_STACK_INCREASE         (120/sizeof(UINT32))
 #else
  #define OS_TIMER_STACK_INCREASE         (20/sizeof(UINT32))
 #endif
#endif    
    
#ifdef __cplusplus
}
#endif

#endif

